#!/bin/bash
n_steps=3
for i in `seq 1 ${n_steps}`;
do
    echo "Iteration: $i"
    command="sbatch --dependency=afterok:$latest_id step_${i}.run"
    if [ $i = 1 ]; then
	command="sbatch step_${i}.run"
    fi
    latest_id=$($command | awk ' { print $4 }')
    echo "Successfully submitted job $latest_id."
done
