#!/bin/bash 
parameter_list=( 100 200 300 )
i=0
job_name="parallel_sum"
for N in "${parameter_list[@]}"
do
    i=$(($i+1))
    echo "Submitting job $i ..."
    echo "Parameter value: $N"
    sbatch -J ${job_name}_${i}     \
	   -o ${job_name}_${i}.out \
	   -e ${job_name}_${i}.err \
	   -p general              \
	   -n 1                    \
           -t 30                   \
	   --mem=2000              \
           --wrap="matlab -nodesktop -nosplash -r 'serial_sum($N);exit'"
    echo ""
    sleep 1
done
